/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.apple2e.SoftSwitches;
import jace.core.Card;
import jace.core.Computer;
import jace.core.PagedMemory;
import jace.core.RAM;
import java.io.IOException;
import java.io.InputStream;

public abstract class RAM128k
extends RAM {
    protected PagedMemory mainMemory = new PagedMemory(49152, PagedMemory.Type.ram);
    protected PagedMemory languageCard;
    protected PagedMemory languageCard2;
    protected PagedMemory cPageRom;
    protected PagedMemory rom = new PagedMemory(12288, PagedMemory.Type.firmwareMain);
    protected PagedMemory blank;

    public RAM128k() {
        this.cPageRom = new PagedMemory(4096, PagedMemory.Type.slotRom);
        this.languageCard = new PagedMemory(12288, PagedMemory.Type.languageCard);
        this.languageCard2 = new PagedMemory(4096, PagedMemory.Type.languageCard);
        this.activeRead = new PagedMemory(65536, PagedMemory.Type.ram);
        this.activeWrite = new PagedMemory(65536, PagedMemory.Type.ram);
        this.blank = new PagedMemory(256, PagedMemory.Type.ram);
        for (int i = 0; i < 256; ++i) {
            this.blank.get((int)0)[i] = -1;
        }
        this.initMemoryPattern(this.mainMemory);
    }

    public void initMemoryPattern(PagedMemory mem) {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 192; ++j) {
                byte use;
                mem.get((int)j)[i] = use = (byte)(i % 4 > 1 ? 255 : 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureActiveMemory() {
        this.log("MMU Switches");
        RAM128k rAM128k = this;
        synchronized (rAM128k) {
            int i;
            block25: {
                block23: {
                    block24: {
                        this.activeRead.fillBanks(SoftSwitches.RAMRD.getState() ? this.getAuxMemory() : this.mainMemory);
                        this.activeWrite.fillBanks(SoftSwitches.RAMWRT.getState() ? this.getAuxMemory() : this.mainMemory);
                        this.activeRead.fillBanks(this.rom);
                        for (i = 192; i < 208; ++i) {
                            this.activeWrite.set(i, null);
                        }
                        if (SoftSwitches.LCRAM.getState()) {
                            if (!SoftSwitches.AUXZP.getState()) {
                                this.activeRead.fillBanks(this.languageCard);
                                if (!SoftSwitches.LCBANK1.getState()) {
                                    this.activeRead.fillBanks(this.languageCard2);
                                }
                            } else {
                                this.activeRead.fillBanks(this.getAuxLanguageCard());
                                if (!SoftSwitches.LCBANK1.getState()) {
                                    this.activeRead.fillBanks(this.getAuxLanguageCard2());
                                }
                            }
                        }
                        if (!SoftSwitches.LCWRITE.getState()) break block23;
                        if (SoftSwitches.AUXZP.getState()) break block24;
                        this.activeWrite.fillBanks(this.languageCard);
                        if (!SoftSwitches.LCBANK1.getState()) {
                            this.activeWrite.fillBanks(this.languageCard2);
                        }
                        break block25;
                    }
                    this.activeWrite.fillBanks(this.getAuxLanguageCard());
                    if (SoftSwitches.LCBANK1.getState()) break block25;
                    this.activeWrite.fillBanks(this.getAuxLanguageCard2());
                    break block25;
                }
                for (i = 208; i < 256; ++i) {
                    this.activeWrite.set(i, null);
                }
            }
            if (SoftSwitches._80STORE.isOn()) {
                this.activeRead.setBanks(4, 4, 4, SoftSwitches.PAGE2.isOn() ? this.getAuxMemory() : this.mainMemory);
                this.activeWrite.setBanks(4, 4, 4, SoftSwitches.PAGE2.isOn() ? this.getAuxMemory() : this.mainMemory);
                if (SoftSwitches.HIRES.isOn()) {
                    this.activeRead.setBanks(32, 32, 32, SoftSwitches.PAGE2.isOn() ? this.getAuxMemory() : this.mainMemory);
                    this.activeWrite.setBanks(32, 32, 32, SoftSwitches.PAGE2.isOn() ? this.getAuxMemory() : this.mainMemory);
                }
            }
            if (SoftSwitches.AUXZP.getState()) {
                this.activeRead.setBanks(0, 2, 0, this.getAuxMemory());
                this.activeWrite.setBanks(0, 2, 0, this.getAuxMemory());
            } else {
                this.activeRead.setBanks(0, 2, 0, this.mainMemory);
                this.activeWrite.setBanks(0, 2, 0, this.mainMemory);
            }
            if (SoftSwitches.CXROM.getState()) {
                this.activeRead.setBanks(0, 15, 193, this.cPageRom);
            } else {
                for (int slot = 1; slot <= 7; ++slot) {
                    Card c = this.getCard(slot);
                    if (c != null) {
                        this.activeRead.setBanks(0, 1, 192 + slot, c.getCxRom());
                        if (this.getActiveSlot() != slot) continue;
                        this.activeRead.setBanks(0, 8, 200, c.getC8Rom());
                        continue;
                    }
                    this.activeRead.set(192 + slot, this.blank.get(0));
                }
                if (this.getActiveSlot() == 0) {
                    for (i = 200; i < 208; ++i) {
                        this.activeRead.set(i, this.blank.get(0));
                    }
                }
                if (SoftSwitches.SLOTC3ROM.isOff()) {
                    this.activeRead.setBanks(2, 1, 195, this.cPageRom);
                }
                if (SoftSwitches.INTC8ROM.getState()) {
                    this.activeRead.setBanks(7, 8, 200, this.cPageRom);
                }
            }
        }
        this.activeRead.set(192, this.blank.get(0));
    }

    public void log(String message) {
        if (Computer.getComputer().cpu != null && Computer.getComputer().cpu.isLogEnabled()) {
            String stack = "";
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                stack = stack + e.getClassName() + "." + e.getMethodName() + "(" + e.getLineNumber() + ");";
            }
            Computer.getComputer().cpu.log(stack);
            Computer.getComputer().cpu.log(message + ";" + (Object)((Object)SoftSwitches.RAMRD) + ";" + (Object)((Object)SoftSwitches.RAMWRT) + ";" + (Object)((Object)SoftSwitches.AUXZP) + ";" + (Object)((Object)SoftSwitches._80STORE) + ";" + (Object)((Object)SoftSwitches.HIRES) + ";" + (Object)((Object)SoftSwitches.PAGE2) + ";" + (Object)((Object)SoftSwitches.LCBANK1) + ";" + (Object)((Object)SoftSwitches.LCRAM) + ";" + (Object)((Object)SoftSwitches.LCWRITE));
        }
    }

    @Override
    protected void loadRom(String path) throws IOException {
        byte[] ignore = new byte[256];
        this.activeWrite.set(0, ignore);
        for (int i = 1; i < 17; ++i) {
            this.activeWrite.set(i, ignore);
        }
        this.activeWrite.setBanks(0, this.cPageRom.getMemory().length, 17, this.cPageRom);
        this.activeWrite.setBanks(0, this.rom.getMemory().length, 32, this.rom);
        InputStream inputRom = this.getClass().getClassLoader().getResourceAsStream(path);
        int read = 0;
        int addr = 0;
        byte[] in = new byte[1024];
        while (addr < 65535 && (read = inputRom.read(in)) > 0) {
            for (int i = 0; i < read; ++i) {
                this.write(addr++, in[i], false, false);
            }
        }
        this.configureActiveMemory();
    }

    public PagedMemory getMainMemory() {
        return this.mainMemory;
    }

    public abstract PagedMemory getAuxVideoMemory();

    public abstract PagedMemory getAuxMemory();

    public abstract PagedMemory getAuxLanguageCard();

    public abstract PagedMemory getAuxLanguageCard2();

    public PagedMemory getLanguageCard() {
        return this.languageCard;
    }

    public PagedMemory getLanguageCard2() {
        return this.languageCard2;
    }

    public PagedMemory getcPageRom() {
        return this.cPageRom;
    }

    public PagedMemory getRom() {
        return this.rom;
    }

    void copyFrom(RAM128k currentMemory) {
        this.blank = currentMemory.blank;
        this.cPageRom = currentMemory.cPageRom;
        this.rom = currentMemory.rom;
        this.listeners = currentMemory.listeners;
        this.mainMemory = currentMemory.mainMemory;
        this.languageCard = currentMemory.languageCard;
        this.languageCard2 = currentMemory.languageCard2;
        this.cards = currentMemory.cards;
        this.activeSlot = currentMemory.activeSlot;
    }
}

